<?php
session_start();

// Redirect to login page if user is not logged in
if (!isset($_SESSION["user_id"])) {
    header("Location: AccountLogin.php");
    exit;
}

$mysqli = require __DIR__ . '/database.php';

// Fetch user details from the database
$user_id = $_SESSION["user_id"];
$sql = "SELECT * FROM user WHERE id = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Handle form submission for updating user details
$update_success = false;
$errors = [];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Validate the new username and email
    $new_username = trim($_POST["username"]);
    $new_email = trim($_POST["email"]);

    if (empty($new_username) || empty($new_email)) {
        $errors[] = "Username and email cannot be empty.";
    } elseif (!filter_var($new_email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email address.";
    }

    // Check for duplicate email (if it's changed)
    if ($new_email !== $user['email']) {
        $sql_check = "SELECT * FROM user WHERE email = ? AND id != ?";
        $stmt_check = $mysqli->prepare($sql_check);
        $stmt_check->bind_param("si", $new_email, $user_id);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            $errors[] = "This email is already in use.";
        }
    }

    // If no errors, update the user details
    if (empty($errors)) {
        $sql_update = "UPDATE user SET name = ?, email = ? WHERE id = ?";
        $stmt_update = $mysqli->prepare($sql_update);
        $stmt_update->bind_param("ssi", $new_username, $new_email, $user_id);

        if ($stmt_update->execute()) {
            $update_success = true;

            // Update session data for username
            $_SESSION["username"] = $new_username;

            // Refresh the user data
            $user['name'] = $new_username;
            $user['email'] = $new_email;
        } else {
            $errors[] = "Failed to update account details.";
        }
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Account</title>
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">
    <style>
        * {
        margin: 0;
        padding: 0;

            }
        body {
            font-family: 'Nunito', sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        
        .container {
            background-color: #0000003a;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
      width: 100%;
      max-width: 400px;
      display: block;
      margin-top: 20px;
    margin-left: auto;
    margin-right: auto;
    position: relative;
    min-width: 400px;
        }

        h1 {
            text-align: center;
            color: #ffffff;
            margin-bottom: 20px;
            font-size: 16px;
            font-family: "Montserrat", sans-serif;
            font-weight: 100;
            font-style: normal;
            text-align: center;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        label {
            margin-bottom: 5px;
            font-weight: bold;
            color: #ffffff;
            font-size: 14px;
            font-family: "Montserrat", sans-serif;
            font-weight: 100;
            font-style: normal;
            text-align: center;
        }

        .AccInput {
            padding: 10px;
            margin-bottom: 20px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
            text-align: center;
        }

        .AccInput:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.3);
            
        }

        .btn1 {
            padding: 10px;
            font-size: 16px;
            color: white;
            background-color: #007bff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            margin-bottom: 10px;
        }

        .btn1:hover {
            background-color: #0056b3;
        }

        .btn1:disabled {
            background-color: #ccc;
        }

        .message {
            text-align: center;
            margin-bottom: 20px;
        }

        .message p {
            margin: 0;
            color: #ebff00;
        }

        .success {
            color: green;
        }

        .logout {
            text-align: center;
            margin-top: 20px;
        }

        .logout a {
            color: #007bff;
            text-decoration: none;
        }

        .logout a:hover {
            text-decoration: underline;
        }
        /* Mobile menu styling */
@media (max-width: 768px) {
    html, body {
    overflow-x: hidden;
}
       /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
}

.hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
}

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
    }

.hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .Account{
        margin-left: -20px;
        margin-top: 10px;
    }
    .container {
            background-color: #0000003a;
      padding: 30px;
      border-radius: 8px;
      box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
      width: 100%;
      max-width: 300px;
      display: block;
      margin-top: 20px;
    margin-left: auto;
    margin-right: auto;
    position: relative;
    min-width: 100px;
        }

        h1 {
            text-align: center;
            color: #ffffff;
            margin-bottom: 20px;
            font-size: 16px;
            font-family: "Montserrat", sans-serif;
            font-weight: 100;
            font-style: normal;
            text-align: center;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        label {
            margin-bottom: 5px;
            font-weight: bold;
            color: #ffffff;
            font-size: 14px;
            font-family: "Montserrat", sans-serif;
            font-weight: 100;
            font-style: normal;
            text-align: center;
        }

        .AccInput {
            padding: 10px;
            margin-bottom: 20px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
            text-align: center;
        }

        .AccInput:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.3);
            
        }

        .btn1 {
            padding: 10px;
            font-size: 16px;
            color: white;
            background-color: #007bff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            margin-bottom: 10px;
        }
}
    </style>
</head>
<body>
<section class="header" id="NavSection">
        <nav class="navbar">
            <a href="Logged.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
            <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
            </div>
            <div class="nav-links" id="navLinks">
            <ul>
                <li class="navButton"><a href="Logged.php">Home</a></li>
                <li class="navButton"><a href="TopPageLogged.php">Top</a></li>
                <li class="navButton"><a href="ArtistsPage.php">Artists</a></li>
                <li class="navButton"><a href="LogoutSession.php">Log out</a></li>
                <li><a href="AccountInfo.php"><img  class="Account" src="Images/pfp.png" alt="Profile_Picture"></a></li>
            </ul>
        </div>
        </nav>
<div class="container">
    <h1>Account Details</h1>

    <?php if ($update_success): ?>
        <div class="message success">
            <p class="success1">Your account details have been updated successfully.</p>
        </div>
    <?php endif; ?>

    <?php if (!empty($errors)): ?>
        <div class="message">
            <?php foreach ($errors as $error): ?>
                <p><?= htmlspecialchars($error) ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Display and update user details -->
    <form action="" method="POST">
        <label for="username">Username</label>
        <input class="AccInput" type="text" id="username" name="username" value="<?= htmlspecialchars($user['name']) ?>" required>

        <label for="email">Email</label>
        <input class="AccInput" type="email" id="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required>

        <button class="btn1" type="submit">Update Account</button>
    </form>

    <div class="logout">
        <a href="LogoutSession.php">Log Out</a>
    </div>
</div>
</section>
<script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>
